<?php
$currentStep = $currentStep ?? 'welcome';
$steps = [
  ['key' => 'welcome', 'label' => 'Bienvenida'],
  ['key' => 'panorama', 'label' => 'Diagnóstico'],
  ['key' => 'datos', 'label' => 'Datos'],
  ['key' => 'imagenes', 'label' => 'Imágenes'],
  ['key' => 'pago', 'label' => 'Pago'],
  ['key' => 'informe', 'label' => 'Informe'],
];
$currentKey = $currentStep === 'result-pos' ? 'pago'
  : ($currentStep === 'result-neg' ? 'imagenes'
  : ($currentStep === 'loading' ? 'imagenes'
  : $currentStep));
$index = 0;
foreach ($steps as $i => $s) {
  if ($s['key'] === $currentKey) { $index = $i; break; }
}
?>
<section class="rounded-2xl border bg-white p-4 shadow-sm">
  <div class="flex items-center justify-between text-xs font-medium text-slate-600">
    <?php foreach ($steps as $i => $s) {
      $isDone = $i < $index;
      $isNow = $i === $index;
      ?>
      <div class="flex items-center gap-2">
        <span class="inline-flex h-6 w-6 items-center justify-center rounded-full text-white <?= $isDone ? 'bg-green-600' : ($isNow ? 'bg-blue-600' : 'bg-slate-200') ?>">
          <?= $isDone ? '✓' : ($i + 1) ?>
        </span>
        <span class="hidden sm:inline"><?= htmlspecialchars($s['label'], ENT_QUOTES, 'UTF-8') ?></span>
      </div>
      <?php if ($i < count($steps) - 1) { ?>
        <div class="mx-2 h-[2px] flex-1 <?= $isDone ? 'bg-green-200' : 'bg-slate-200' ?>"></div>
      <?php } ?>
    <?php } ?>
  </div>
</section>
