<?php
$isActive = ($currentStep ?? '') === 'result-pos';
$resultPos = $resultPos ?? [];
$datos = $datos ?? [];
$solicitudId = $resultPos['solicitud_id'] ?? ($datos['solicitud_id'] ?? 0);
?>
<section id="view-result-pos" class="view space-y-6 <?= $isActive ? '' : 'hidden' ?>">
  <div class="rounded-2xl border bg-white p-6 shadow-sm">
    <div class="flex items-start gap-3">
      <div class="mt-1 flex h-10 w-10 items-center justify-center rounded-2xl bg-green-50 text-green-700">
        <span class="text-lg">✅</span>
      </div>
      <div class="flex-1">
        <h2 class="text-xl font-semibold tracking-tight">Evaluación completada</h2>
        <p class="mt-2 text-sm text-slate-600">
          Pudimos evaluar los daños. Para obtener el informe completo en PDF, realiza el pago.
        </p>

        <div class="mt-4 grid grid-cols-1 gap-3 sm:grid-cols-2">
          <div class="rounded-xl border p-4">
            <div class="text-xs text-slate-500">Patente</div>
            <div class="mt-1 text-sm font-semibold"><?= htmlspecialchars($datos['plate'] ?? '—', ENT_QUOTES, 'UTF-8') ?></div>
          </div>
          <div class="rounded-xl border p-4">
            <div class="text-xs text-slate-500">Fecha</div>
            <div class="mt-1 text-sm font-semibold">Hoy</div>
          </div>
        </div>

        <?php if (!empty($resultPos)) { ?>
          <div class="mt-4 rounded-xl border p-4 text-sm">
            <div><span class="text-slate-500">Tipo de auto:</span> <?= htmlspecialchars($resultPos['tipo_auto'] ?? '—', ENT_QUOTES, 'UTF-8') ?></div>
            <div><span class="text-slate-500">Costo total:</span> $<?= number_format((float)($resultPos['costo_total'] ?? 0), 0, ',', '.') ?></div>
            <div class="mt-2 text-slate-600"><?= htmlspecialchars($resultPos['descripcion'] ?? '', ENT_QUOTES, 'UTF-8') ?></div>
          </div>
        <?php } ?>

        <div class="mt-6 space-y-3">
          <div class="rounded-2xl border bg-yellow-50 p-4">
            <div class="text-sm font-semibold text-yellow-900">Pago demo Mercado Pago</div>
            <p class="mt-1 text-xs text-yellow-800">Simula un pago aprobado o rechazado para continuar.</p>
          </div>
          <form method="post" action="<?= ($assetBase ?? '') ?>/pago" class="space-y-3">
            <input type="hidden" name="solicitud_id" value="<?= (int)$solicitudId ?>" />
            <button name="result" value="success" class="inline-flex w-full items-center justify-center rounded-xl bg-blue-600 px-4 py-3 text-sm font-semibold text-white shadow-sm hover:bg-blue-700">
              ✅ Pagar (aprobado)
            </button>
            <button name="result" value="fail" class="inline-flex w-full items-center justify-center rounded-xl border px-4 py-3 text-sm font-semibold text-slate-700 hover:bg-slate-50">
              ❌ Pagar (rechazado)
            </button>
          </form>
        </div>
      </div>
    </div>
  </div>
</section>
