<?php
$isActive = ($currentStep ?? '') === 'imagenes';
$datos = $datos ?? [];
$token = $_SESSION['form_token'] ?? '';
$attemptInfo = $attemptInfo ?? null;
$attemptNumber = $attemptInfo ? min(3, (int)$attemptInfo['attempts'] + 1) : 1;
?>
<section id="view-imagenes" class="view space-y-6 <?= $isActive ? '' : 'hidden' ?>">
  <div class="rounded-2xl border bg-white p-6 shadow-sm">
    <div class="flex items-start justify-between gap-4">
      <div>
        <h2 class="text-xl font-semibold tracking-tight">Sube fotos del vehículo</h2>
        <p class="mt-2 text-sm text-slate-600">
          Solo puedes enviar un máximo de <span class="font-semibold">3 intentos</span>.
        </p>
      </div>
      <div id="attemptBadge" class="rounded-full bg-slate-100 px-3 py-1 text-xs font-semibold text-slate-700">
        Intento <?= $attemptNumber ?> de 3
      </div>
    </div>

    <form id="formImages" class="mt-6 space-y-4" method="post" action="<?= ($assetBase ?? '') ?>/imagenes" enctype="multipart/form-data">
      <input type="hidden" name="token" value="<?= htmlspecialchars($token, ENT_QUOTES, 'UTF-8') ?>" />
      <input type="hidden" name="name" value="<?= htmlspecialchars($datos['name'] ?? '', ENT_QUOTES, 'UTF-8') ?>" />
      <input type="hidden" name="rut" value="<?= htmlspecialchars($datos['rut'] ?? '', ENT_QUOTES, 'UTF-8') ?>" />
      <input type="hidden" name="plate" value="<?= htmlspecialchars($datos['plate'] ?? '', ENT_QUOTES, 'UTF-8') ?>" />
      <input type="hidden" name="email" value="<?= htmlspecialchars($datos['email'] ?? '', ENT_QUOTES, 'UTF-8') ?>" />

      <div class="rounded-2xl border p-4">
        <div class="flex items-center justify-between gap-3">
          <div>
            <div class="text-sm font-semibold">Foto 1 – Frontal</div>
            <div class="text-xs text-slate-500">Incluye el vehículo completo.</div>
          </div>
          <label class="inline-flex cursor-pointer items-center justify-center rounded-xl bg-blue-600 px-4 py-2.5 text-sm font-semibold text-white hover:bg-blue-700">
            📷 Tomar foto
            <input id="file1" name="images[]" type="file" accept="image/png,image/jpeg" capture="environment" class="hidden image-input" required />
          </label>
        </div>
        <div id="prev1" class="mt-4 flex h-40 items-center justify-center rounded-xl border border-dashed bg-slate-50 text-sm text-slate-500 image-preview">
          Vista previa
        </div>
      </div>

      <div class="rounded-2xl border p-4">
        <div class="flex items-center justify-between gap-3">
          <div>
            <div class="text-sm font-semibold">Foto 2 – Lateral / daño</div>
            <div class="text-xs text-slate-500">Acércate, pero mantén el enfoque.</div>
          </div>
          <label class="inline-flex cursor-pointer items-center justify-center rounded-xl bg-blue-600 px-4 py-2.5 text-sm font-semibold text-white hover:bg-blue-700">
            📷 Tomar foto
            <input id="file2" name="images[]" type="file" accept="image/png,image/jpeg" capture="environment" class="hidden image-input" required />
          </label>
        </div>
        <div id="prev2" class="mt-4 flex h-40 items-center justify-center rounded-xl border border-dashed bg-slate-50 text-sm text-slate-500 image-preview">
          Vista previa
        </div>
      </div>

      <div class="rounded-2xl border p-4">
        <div class="flex items-center justify-between gap-3">
          <div>
            <div class="text-sm font-semibold">Foto 3 – Trasera / contexto</div>
            <div class="text-xs text-slate-500">Incluye entorno si es posible.</div>
          </div>
          <label class="inline-flex cursor-pointer items-center justify-center rounded-xl bg-blue-600 px-4 py-2.5 text-sm font-semibold text-white hover:bg-blue-700">
            📷 Tomar foto
            <input id="file3" name="images[]" type="file" accept="image/png,image/jpeg" capture="environment" class="hidden image-input" required />
          </label>
        </div>
        <div id="prev3" class="mt-4 flex h-40 items-center justify-center rounded-xl border border-dashed bg-slate-50 text-sm text-slate-500 image-preview">
          Vista previa
        </div>
      </div>

      <div id="extraImages"></div>

      <div class="flex items-center justify-between gap-3">
        <div class="text-xs text-slate-500">Puedes agregar hasta 6 imágenes en total.</div>
        <button type="button" id="btnAddImage"
          class="inline-flex items-center justify-center rounded-xl border px-3 py-2 text-xs font-semibold text-slate-700 hover:bg-slate-50">
          + Agregar imagen
        </button>
      </div>

      <button id="btnSendImages" type="submit"
        class="inline-flex w-full items-center justify-center rounded-xl bg-blue-600 px-4 py-3 text-sm font-semibold text-white shadow-sm hover:bg-blue-700 disabled:cursor-not-allowed disabled:bg-slate-300">
        Enviar imágenes para evaluación
      </button>
    </form>
  </div>
</section>
