<?php
$isActive = ($currentStep ?? '') === 'datos';
$old = $old ?? [];
$errors = $errors ?? [];
$fechaIngreso = $fechaIngreso ?? '';
?>
<section id="view-datos" class="view space-y-6 <?= $isActive ? '' : 'hidden' ?>">
  <div class="rounded-2xl border bg-white p-6 shadow-sm">
    <h2 class="text-xl font-semibold tracking-tight">Identificación del solicitante</h2>
    <p class="mt-2 text-sm text-slate-600">
      Validaremos si ya existe un informe vigente para hoy.
    </p>

    <form id="formDatos" class="mt-6 space-y-4" method="post" action="<?= ($assetBase ?? '') ?>/datos" novalidate>
      <div>
        <label class="text-sm font-medium text-slate-700">Nombre completo</label>
        <input id="inpName" name="name" required value="<?= htmlspecialchars($old['name'] ?? '', ENT_QUOTES, 'UTF-8') ?>"
          class="mt-2 w-full rounded-xl border px-4 py-3 text-sm outline-none focus:border-blue-500 focus:ring-4 focus:ring-blue-100"
          placeholder="Ej: Juan Pérez" />
        <?php if (!empty($errors['name'])) { ?>
          <p class="mt-1 text-xs text-red-600"><?= htmlspecialchars($errors['name'], ENT_QUOTES, 'UTF-8') ?></p>
        <?php } ?>
      </div>

      <div>
        <label class="text-sm font-medium text-slate-700">RUT</label>
        <input id="inpRut" name="rut" required value="<?= htmlspecialchars($old['rut'] ?? '', ENT_QUOTES, 'UTF-8') ?>"
          class="mt-2 w-full rounded-xl border px-4 py-3 text-sm outline-none focus:border-blue-500 focus:ring-4 focus:ring-blue-100"
          placeholder="Ej: 12.345.678-9" />
        <p class="mt-1 text-xs text-slate-500">Se valida con dígito verificador.</p>
        <?php if (!empty($errors['rut'])) { ?>
          <p class="mt-1 text-xs text-red-600"><?= htmlspecialchars($errors['rut'], ENT_QUOTES, 'UTF-8') ?></p>
        <?php } ?>
      </div>

      <div>
        <label class="text-sm font-medium text-slate-700">Patente</label>
        <input id="inpPlate" name="plate" required value="<?= htmlspecialchars($old['plate'] ?? '', ENT_QUOTES, 'UTF-8') ?>"
          class="mt-2 w-full rounded-xl border px-4 py-3 text-sm uppercase tracking-wider outline-none focus:border-blue-500 focus:ring-4 focus:ring-blue-100"
          placeholder="Ej: XXYY11 o AB-CD-12" />
        <p class="mt-1 text-xs text-slate-500">Acepta formatos antiguos y nuevos (con o sin guion).</p>
        <?php if (!empty($errors['plate'])) { ?>
          <p class="mt-1 text-xs text-red-600"><?= htmlspecialchars($errors['plate'], ENT_QUOTES, 'UTF-8') ?></p>
        <?php } ?>
      </div>

      <div>
        <label class="text-sm font-medium text-slate-700">Correo electrónico</label>
        <input id="inpEmail" name="email" required type="email" value="<?= htmlspecialchars($old['email'] ?? '', ENT_QUOTES, 'UTF-8') ?>"
          class="mt-2 w-full rounded-xl border px-4 py-3 text-sm outline-none focus:border-blue-500 focus:ring-4 focus:ring-blue-100"
          placeholder="Ej: nombre@correo.cl" />
        <?php if (!empty($errors['email'])) { ?>
          <p class="mt-1 text-xs text-red-600"><?= htmlspecialchars($errors['email'], ENT_QUOTES, 'UTF-8') ?></p>
        <?php } ?>
      </div>

      <div>
        <label class="text-sm font-medium text-slate-700">Fecha de ingreso (interno)</label>
        <input type="text" readonly value="<?= htmlspecialchars($fechaIngreso, ENT_QUOTES, 'UTF-8') ?>"
          class="mt-2 w-full rounded-xl border bg-slate-50 px-4 py-3 text-sm text-slate-600" />
      </div>

      <button type="submit" class="inline-flex w-full items-center justify-center rounded-xl bg-blue-600 px-4 py-3 text-sm font-semibold text-white shadow-sm hover:bg-blue-700">
        Enviar e iniciar evaluación
      </button>
    </form>
  </div>
</section>
