<?php
$toast = $toast ?? null;
$toastType = is_array($toast) ? ($toast['type'] ?? '') : '';
$toastTitle = is_array($toast) ? ($toast['title'] ?? '') : '';
$toastMessage = is_array($toast) ? ($toast['message'] ?? '') : '';
$toastStyles = [
  'info' => 'border-blue-200 bg-blue-50 text-blue-900',
  'ok' => 'border-green-200 bg-green-50 text-green-900',
  'warn' => 'border-amber-200 bg-amber-50 text-amber-900',
  'err' => 'border-red-200 bg-red-50 text-red-900',
];
$toastClass = $toastType && isset($toastStyles[$toastType]) ? $toastStyles[$toastType] : '';
$toastVisible = $toastType && $toastTitle;
?>
<div id="toast" class="<?= $toastVisible ? 'rounded-2xl border p-4 shadow-sm ' . $toastClass : 'hidden rounded-2xl border p-4 shadow-sm' ?>">
  <?php if ($toastVisible) { ?>
    <div class="font-semibold text-sm"><?= htmlspecialchars($toastTitle, ENT_QUOTES, 'UTF-8') ?></div>
    <div class="mt-1 text-sm opacity-90"><?= htmlspecialchars($toastMessage, ENT_QUOTES, 'UTF-8') ?></div>
  <?php } ?>
</div>
