<?php $isActive = ($currentStep ?? 'welcome') === 'welcome'; ?>
<section id="view-welcome" class="view space-y-6 <?= $isActive ? '' : 'hidden' ?>">
  <div class="rounded-2xl border bg-white p-6 shadow-sm">
    <div class="flex items-start gap-3">
      <div class="mt-1 flex h-10 w-10 items-center justify-center rounded-2xl bg-blue-50 text-blue-700">
        <span class="text-lg">🚗</span>
      </div>
      <div class="flex-1">
        <h1 class="text-2xl font-semibold tracking-tight">Evalúa daños de tu vehículo en minutos</h1>
        <p class="mt-2 text-sm leading-relaxed text-slate-600">
          Sube fotos claras de tu vehículo y revisaremos si es posible generar un informe de daños.
          Este servicio no reemplaza una inspección presencial ni atención de emergencia.
        </p>

        <ul class="mt-4 space-y-2 text-sm text-slate-700">
          <li class="flex items-center gap-2"><span class="text-green-600">✓</span> 100% online desde tu celular</li>
          <li class="flex items-center gap-2"><span class="text-green-600">✓</span> Informe descargable en PDF</li>
          <li class="flex items-center gap-2"><span class="text-green-600">✓</span> Disponible solo por hoy</li>
        </ul>

        <div class="mt-6 flex flex-col gap-3 sm:flex-row">
          <a href="/?step=panorama" class="inline-flex items-center justify-center rounded-xl bg-blue-600 px-4 py-3 text-sm font-semibold text-white shadow-sm hover:bg-blue-700">
            Iniciar evaluación
          </a>
          <button type="button" data-open-modal="help" class="inline-flex items-center justify-center rounded-xl border px-4 py-3 text-sm font-semibold text-slate-700 hover:bg-slate-50">
            Tengo una emergencia
          </button>
        </div>

        <p class="mt-4 text-xs text-slate-500">
          Al continuar, confirmas que comprendes el alcance del servicio y aceptas los términos.
        </p>
      </div>
    </div>
  </div>
</section>
