<?php
$isActive = ($currentStep ?? '') === 'result-neg';
$resultNeg = $resultNeg ?? [];
$remaining = isset($resultNeg['remaining']) ? (int)$resultNeg['remaining'] : null;
?>
<section id="view-result-neg" class="view space-y-6 <?= $isActive ? '' : 'hidden' ?>">
  <div class="rounded-2xl border bg-white p-6 shadow-sm">
    <div class="flex items-start gap-3">
      <div class="mt-1 flex h-10 w-10 items-center justify-center rounded-2xl bg-red-50 text-red-700">
        <span class="text-lg">❌</span>
      </div>
      <div class="flex-1">
        <h2 class="text-xl font-semibold tracking-tight">No fue posible evaluar</h2>
        <p class="mt-2 text-sm text-slate-600">
          <?= htmlspecialchars($resultNeg['message'] ?? 'Las imágenes no son lo suficientemente claras.', ENT_QUOTES, 'UTF-8') ?>
        </p>

        <div class="mt-6 flex flex-col gap-3 sm:flex-row">
          <?php if ($remaining === null || $remaining > 0) { ?>
            <a href="/?step=imagenes" class="inline-flex flex-1 items-center justify-center rounded-xl bg-blue-600 px-4 py-3 text-sm font-semibold text-white hover:bg-blue-700">
              Reintentar
            </a>
          <?php } ?>
          <a href="/?step=welcome" class="inline-flex flex-1 items-center justify-center rounded-xl border px-4 py-3 text-sm font-semibold text-slate-700 hover:bg-slate-50">
            Volver al inicio
          </a>
        </div>

        <?php if ($remaining !== null) { ?>
          <p class="mt-3 text-xs text-slate-500">Intentos disponibles: <?= $remaining ?></p>
        <?php } ?>
      </div>
    </div>
  </div>
</section>
