<?php $isActive = ($currentStep ?? '') === 'panorama'; ?>
<section id="view-panorama" class="view space-y-6 <?= $isActive ? '' : 'hidden' ?>">
  <div class="rounded-2xl border bg-white p-6 shadow-sm">
    <h2 class="text-xl font-semibold tracking-tight">Panorama general del accidente</h2>
    <p class="mt-2 text-sm text-slate-600">
      Confirma que no se trata de un caso donde no podamos evaluar correctamente.
    </p>

    <?php $panorama = $panorama ?? []; ?>
    <form id="formPanorama" class="mt-6 space-y-4" method="post" action="/panorama">
      <div class="rounded-xl border p-4">
        <div class="flex flex-col gap-3 sm:flex-row sm:items-center sm:justify-between">
          <div>
            <div class="text-sm font-semibold">¿Existen heridos o fallecidos?</div>
            <div class="text-xs text-slate-500">Si respondes “Sí”, no continuaremos con diagnóstico.</div>
          </div>
          <div class="flex gap-2">
            <label class="inline-flex items-center gap-2 rounded-lg border px-3 py-2 text-sm hover:bg-slate-50">
                    <input type="radio" name="injury" value="no" class="accent-blue-600" <?= (($panorama['injury'] ?? 'no') === 'no') ? 'checked' : '' ?> />
              No
            </label>
            <label class="inline-flex items-center gap-2 rounded-lg border px-3 py-2 text-sm hover:bg-slate-50">
                    <input type="radio" name="injury" value="si" class="accent-blue-600" <?= (($panorama['injury'] ?? 'no') === 'si') ? 'checked' : '' ?> />
              Sí
            </label>
          </div>
        </div>
      </div>

      <div class="rounded-xl border p-4">
        <div class="flex flex-col gap-3 sm:flex-row sm:items-center sm:justify-between">
          <div>
            <div class="text-sm font-semibold">¿El auto se incendió?</div>
            <div class="text-xs text-slate-500">Incendios requieren evaluación presencial.</div>
          </div>
          <div class="flex gap-2">
            <label class="inline-flex items-center gap-2 rounded-lg border px-3 py-2 text-sm hover:bg-slate-50">
                    <input type="radio" name="fire" value="no" class="accent-blue-600" <?= (($panorama['fire'] ?? 'no') === 'no') ? 'checked' : '' ?> />
              No
            </label>
            <label class="inline-flex items-center gap-2 rounded-lg border px-3 py-2 text-sm hover:bg-slate-50">
                    <input type="radio" name="fire" value="si" class="accent-blue-600" <?= (($panorama['fire'] ?? 'no') === 'si') ? 'checked' : '' ?> />
              Sí
            </label>
          </div>
        </div>
      </div>

      <div class="rounded-xl border p-4">
        <div class="flex flex-col gap-3 sm:flex-row sm:items-center sm:justify-between">
          <div>
            <div class="text-sm font-semibold">¿El motor no enciende?</div>
            <div class="text-xs text-slate-500">Podría indicar daño no visible en imágenes.</div>
          </div>
          <div class="flex gap-2">
            <label class="inline-flex items-center gap-2 rounded-lg border px-3 py-2 text-sm hover:bg-slate-50">
                    <input type="radio" name="engine" value="no" class="accent-blue-600" <?= (($panorama['engine'] ?? 'no') === 'no') ? 'checked' : '' ?> />
              No
            </label>
            <label class="inline-flex items-center gap-2 rounded-lg border px-3 py-2 text-sm hover:bg-slate-50">
                    <input type="radio" name="engine" value="si" class="accent-blue-600" <?= (($panorama['engine'] ?? 'no') === 'si') ? 'checked' : '' ?> />
              Sí
            </label>
          </div>
        </div>
      </div>

      <div class="rounded-xl border p-4">
        <div class="flex flex-col gap-3 sm:flex-row sm:items-center sm:justify-between">
          <div>
            <div class="text-sm font-semibold">¿Hay derrame de combustible?</div>
            <div class="text-xs text-slate-500">Situación de riesgo (no continuamos).</div>
          </div>
          <div class="flex gap-2">
            <label class="inline-flex items-center gap-2 rounded-lg border px-3 py-2 text-sm hover:bg-slate-50">
                    <input type="radio" name="fuel" value="no" class="accent-blue-600" <?= (($panorama['fuel'] ?? 'no') === 'no') ? 'checked' : '' ?> />
              No
            </label>
            <label class="inline-flex items-center gap-2 rounded-lg border px-3 py-2 text-sm hover:bg-slate-50">
                    <input type="radio" name="fuel" value="si" class="accent-blue-600" <?= (($panorama['fuel'] ?? 'no') === 'si') ? 'checked' : '' ?> />
              Sí
            </label>
          </div>
        </div>
      </div>

      <div id="panoramaBlock" class="<?= !empty($panoramaError) ? '' : 'hidden ' ?>rounded-2xl border border-red-200 bg-red-50 p-4">
        <div class="flex items-start gap-3">
          <div class="mt-0.5 text-xl">🚨</div>
          <div class="flex-1">
            <div class="text-sm font-semibold text-red-900">No podemos realizar diagnóstico con seguridad</div>
            <p class="mt-1 text-sm text-red-800">
              Lamentablemente no podemos brindar un diagnóstico porque no podemos evaluar correctamente los daños.
            </p>
            <div class="mt-4 grid grid-cols-1 gap-2 sm:grid-cols-2">
              <div class="rounded-xl border border-red-200 bg-white p-3 text-sm">🚑 Ambulancia: <span class="font-semibold">131</span></div>
              <div class="rounded-xl border border-red-200 bg-white p-3 text-sm">🚓 Carabineros: <span class="font-semibold">133</span></div>
              <div class="rounded-xl border border-red-200 bg-white p-3 text-sm">🚒 Bomberos: <span class="font-semibold">132</span></div>
              <div class="rounded-xl border border-red-200 bg-white p-3 text-sm">🛻 Grúa: <span class="font-semibold">+56 9 XXXX XXXX</span></div>
            </div>
            <div class="mt-4">
              <a href="/?step=welcome"
                class="inline-flex w-full items-center justify-center rounded-xl border border-red-200 bg-white px-4 py-2.5 text-sm font-semibold text-red-700 hover:bg-red-100">
                Volver al inicio
              </a>
            </div>
          </div>
        </div>
      </div>

      <button id="btnPanoramaContinue" type="submit"
        class="inline-flex w-full items-center justify-center rounded-xl bg-blue-600 px-4 py-3 text-sm font-semibold text-white shadow-sm hover:bg-blue-700 disabled:cursor-not-allowed disabled:bg-slate-300">
        Continuar
      </button>

      <p class="mt-2 text-xs text-slate-500">
        Si seleccionas “Sí” en cualquier opción, puede que no podamos continuar.
      </p>
    </form>
  </div>
</section>
