<?php
$isActive = ($currentStep ?? '') === 'informe';
$informe = $informe ?? null;
?>
<section id="view-informe" class="view space-y-6 <?= $isActive ? '' : 'hidden' ?>">
  <div class="rounded-2xl border bg-white p-6 shadow-sm">
    <div class="flex items-start gap-3">
      <div class="mt-1 flex h-10 w-10 items-center justify-center rounded-2xl bg-indigo-50 text-indigo-700">
        <span class="text-lg">📄</span>
      </div>
      <div class="flex-1">
        <h2 class="text-xl font-semibold tracking-tight">Tu informe está listo</h2>
        <p class="mt-2 text-sm text-slate-600">
          Puedes descargar el informe en PDF. Este documento estará disponible solo por hoy.
        </p>

        <?php if ($informe) { ?>
          <div class="mt-5 rounded-2xl border bg-slate-50 p-4 space-y-2 text-sm">
            <div class="flex items-center justify-between">
              <div class="font-semibold">Solicitud #<?= (int)$informe['id_solicitud'] ?></div>
              <div class="text-xs text-slate-500"><?= htmlspecialchars($informe['fecha'], ENT_QUOTES, 'UTF-8') ?></div>
            </div>
            <div><span class="text-slate-500">Nombre:</span> <?= htmlspecialchars($informe['nombre'], ENT_QUOTES, 'UTF-8') ?></div>
            <div><span class="text-slate-500">RUT:</span> <?= htmlspecialchars($informe['rut'], ENT_QUOTES, 'UTF-8') ?></div>
            <div><span class="text-slate-500">Patente:</span> <?= htmlspecialchars($informe['patente'], ENT_QUOTES, 'UTF-8') ?></div>
            <div><span class="text-slate-500">Tipo de auto:</span> <?= htmlspecialchars($informe['tipo_auto'], ENT_QUOTES, 'UTF-8') ?></div>
            <div><span class="text-slate-500">Costo total:</span> $<?= number_format((float)$informe['costo_total'], 0, ',', '.') ?></div>
            <div><span class="text-slate-500">Descripción:</span> <?= htmlspecialchars($informe['descripcion'], ENT_QUOTES, 'UTF-8') ?></div>
          </div>
        <?php } else { ?>
          <div class="mt-5 rounded-2xl border bg-slate-50 p-4 text-sm text-slate-600">
            No hay un informe disponible para mostrar.
          </div>
        <?php } ?>

        <div class="mt-6 flex flex-col gap-3 sm:flex-row">
          <button id="btnDownload" type="button" class="inline-flex flex-1 items-center justify-center rounded-xl bg-green-600 px-4 py-3 text-sm font-semibold text-white shadow-sm hover:bg-green-700">
            Descargar PDF (demo)
          </button>
          <a href="/?step=welcome" class="inline-flex flex-1 items-center justify-center rounded-xl border px-4 py-3 text-sm font-semibold text-slate-700 hover:bg-slate-50">
            Volver al inicio
          </a>
        </div>

        <p class="mt-3 text-xs text-slate-500">
          Los informes se guardan solo durante el día y luego se eliminan automáticamente.
        </p>
      </div>
    </div>
  </div>
</section>
