<?php
$initialStep = $initialStep ?? null;
$currentStep = $currentStep ?? ($initialStep ?: 'welcome');
?>
<!doctype html>
<html lang="es">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Choque.cl – WebApp Mock (PWA single-file)</title>

  <script src="https://cdn.tailwindcss.com"></script>

  <meta name="theme-color" content="#2563eb" />
  <meta name="description" content="Choque.cl – Evaluación digital de daños mediante fotos. WebApp instalable (PWA)." />

  <meta name="apple-mobile-web-app-capable" content="yes" />
  <meta name="apple-mobile-web-app-status-bar-style" content="default" />
  <meta name="apple-mobile-web-app-title" content="Choque.cl" />

  <link id="manifestLink" rel="manifest" href="" />
  <link id="appleTouchIcon" rel="apple-touch-icon" href="" />
</head>

<body class="bg-slate-50 text-slate-900">
  <?php include __DIR__ . '/../partials/header.php'; ?>

  <main class="mx-auto max-w-6xl px-4 py-10">
    <div class="mx-auto max-w-xl space-y-6">
      <?php include __DIR__ . '/../partials/stepper.php'; ?>
      <?php include __DIR__ . '/../partials/toast.php'; ?>

      <?php include __DIR__ . '/../pages/welcome.php'; ?>
      <?php include __DIR__ . '/../pages/panorama.php'; ?>
      <?php include __DIR__ . '/../pages/datos.php'; ?>
      <?php include __DIR__ . '/../pages/imagenes.php'; ?>
      <?php include __DIR__ . '/../pages/loading.php'; ?>
      <?php include __DIR__ . '/../pages/result-neg.php'; ?>
      <?php include __DIR__ . '/../pages/result-pos.php'; ?>
      <?php include __DIR__ . '/../pages/informe.php'; ?>

      <?php include __DIR__ . '/../partials/footer.php'; ?>
    </div>
  </main>

  <?php include __DIR__ . '/../partials/modal-help.php'; ?>

  <script src="/assets/app.js"></script>
</body>
</html>
